// data-wow-duration="1s" data-wow-delay="0s" data-wow-offset="100"  data-wow-iteration="1"
var wow = new WOW(
    {
        boxClass: 'wow', // animated element css class (default is wow)
        animateClass: 'animated', // animation css class (default is animated)
        offset: 150, // distance to the element when triggering the animation (default is 0)
        mobile: false, // trigger animations on mobile devices (default is true)
        live: true // act on asynchronously loaded content (default is true)
    }
);
wow.init();


function onScrollInit( items, trigger ) {
    items.each( function () {
        var osElement = $( this ),
            osAnimationClass = osElement.attr( 'data-os-animation' ),
            osAnimationDelay = osElement.attr( 'data-os-animation-delay' );

        osElement.css( {
            '-webkit-animation-delay': osAnimationDelay,
            '-moz-animation-delay': osAnimationDelay,
            'animation-delay': osAnimationDelay
        } );

        var osTrigger = ( trigger ) ? trigger : osElement;

        osTrigger.waypoint( function () {
            osElement.addClass( 'animated' ).addClass( osAnimationClass );
        }, {
            triggerOnce: true,
            offset: '90%'
        } );
    } );
}
$( document ).ready( function () {
    onScrollInit( $( '.os-animation' ) );

    // www.jqueryscript.net/animation/jQuery-Plugin-For-Particle-System-Background-with-Parallax-Effect-Particleground.html
    $( '#shorten' ).particleground( {
        //minSpeedX: 0.1,
        //maxSpeedX: 0.7,
        //minSpeedY: 0.1,
        //maxSpeedY: 0.7,
        //directionX: 'center', // 'center', 'left' or 'right'. 'center' = dots bounce off edges
        //directionY: 'center', // 'center', 'up' or 'down'. 'center' = dots bounce off edges
        density: 15000, // How many particles will be generated: one particle every n pixels
        dotColor: '#fcfcfc',
        lineColor: '#fcfcfc',
        particleRadius: 1.5, // Dot size
        lineWidth: 0.25,
        curvedLines: false,
        proximity: 100, // How close two dots need to be before they join
        parallax: false,
        parallaxMultiplier: 5, // The lower the number, the more extreme the parallax effect
        onInit: function () {},
        onDestroy: function () {}
    } );

} );


$( '#shorten button' ).hover(
    function () {
        $( this ).removeClass( 'wow tada animated' ).removeAttr( 'style' ).addClass( 'animated infinite pulse' );
    }, function () {
    $( this ).removeClass( 'animated infinite pulse' );
}
);

$( '.display-counter' ).counterUp( {
    delay: 10,
    time: 1000
} );


function camelcase( inputstring ) {
    var a = inputstring.split( '_' ), i;
    s = [ ];
    for ( i = 0; i < a.length; i++ ) {
        s.push( a[i].charAt( 0 ).toUpperCase() + a[i].substring( 1 ) );
    }
    s = s.join( '' );
    return s;
}

// http://www.php-dev-zone.com/2014/10/ajax-call-validation-in-cakephp.html
$( "#LinkAjaxAddForm" ).submit( function ( e ) {

    e.preventDefault();
    var homeForm = $( this );
    var homeFormHTML = $( this ).html();
    var submitButton = homeForm.find( 'button' );
    var submitButtoHTML = submitButton.html();

    //console.log( homeForm.serialize() );

    $.ajax( {
        dataType: 'json', // The type of data that you're expecting back from the server.
        type: 'POST', // he HTTP method to use for the request
        url: homeForm.attr( 'action' ), // A string containing the URL to which the request is sent.
        data: homeForm.serialize(), // Data to be sent to the server.
        cache: false,
        beforeSend: function ( xhr ) {
            submitButton.attr( "disabled", true ).html( '<i class="fa fa-spinner fa-spin"></i>' );
            //homeForm.slideUp();
            $( "#shorten .error-message" ).remove();
            $( '<div class="loader"></div>' ).insertAfter( homeForm );

        },
        success: function ( result, status, xhr ) {
            //console.log( result );
            if ( result.status === 'success' ) {
                homeForm.slideUp();
                var short_url = app_vars['base_url'] + result.message;
                var short_url_html = '<input class="form-control input-lg" value="' + short_url + '" readonly onfocus="javascript:this.select()" >';
                $( "#shorten .add-link-result" ).html( short_url_html ).slideDown();
            } else {
                submitButton.attr( 'disabled', false ).html( submitButtoHTML );
                $.each( result.errors, function ( model, errors ) {
                    for ( var fieldName in this ) {
                        var element = $( "#" + camelcase( model + '_' + fieldName ) ).parent();
                        var create = $( document.createElement( 'div' ) ).insertAfter( element );
                        create.addClass( 'error-message' ).text( this[fieldName][0] );
                    }
                } );

            }

        },
        error: function ( xhr, status, error ) {
            //homeForm.slideUp();
            alert( "An error occured: " + xhr.status + " " + xhr.statusText );
        },
        complete: function ( xhr, status ) {
            $( '#shorten .loader' ).remove();
        }
    } );

} );

/**
 * Contact Form
 */
$( "#FormContactForm" ).submit( function ( e ) {

    e.preventDefault();
    var contactForm = $( this );
    var contactFormHTML = $( this ).html();
    var submitButton = contactForm.find( 'button' );
    var submitButtonHTML = submitButton.html();

    //console.log( homeForm.serialize() );

    $.ajax( {
        dataType: 'json', // The type of data that you're expecting back from the server.
        type: 'POST', // he HTTP method to use for the request
        url: contactForm.attr( 'action' ), // A string containing the URL to which the request is sent.
        data: contactForm.serialize(), // Data to be sent to the server.
        cache: false,
        beforeSend: function ( xhr ) {
            submitButton.attr( "disabled", true ).html( '<i class="fa fa-spinner fa-spin"></i>' );
            //homeForm.slideUp();
            $( "#contact .error-message" ).remove();
            $( '<div class="loader"></div>' ).insertAfter( contactForm );

        },
        success: function ( result, status, xhr ) {
            //console.log( result );
            if ( result.status === 'success' ) {
                contactForm.slideUp();
                var success_message = '<div class="alert alert-success" role="alert"><b>Well done!</b> ' + result.message + '</div>';
                $( "#contact .contact-result" ).html( success_message ).slideDown();
            } else {
                submitButton.attr( 'disabled', false ).html( submitButtonHTML );
                if ( result.errors ) {
                    $.each( result.errors, function ( model, errors ) {
                        for ( var fieldName in this ) {
                            var element = $( "#" + camelcase( model + '_' + fieldName ) );
                            var create = $( document.createElement( 'div' ) ).insertAfter( element );
                            create.addClass( 'error-message' ).text( this[fieldName][0] );
                        }
                    } );
                }
                var recaptchaError = '';
                if ( typeof grecaptcha != "undefined" ) {
                    grecaptcha.reset();
                    recaptchaError = 'Please enter captcha.';
                }

                var success_message = '<div class="alert alert-danger" role="alert"><b>Error!</b> ' + result.message + ' ' + recaptchaError + '</div>';
                $( "#contact .contact-result" ).html( success_message ).slideDown();

            }

        },
        error: function ( xhr, status, error ) {
            console.table( xhr );
            alert( "An error occured: " + xhr.status + " " + xhr.statusText );
        },
        complete: function ( xhr, status ) {
            $( '#contact .loader' ).remove();
        }
    } );

} );